/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.AbstractStepType;
import com.quantumdata.sct.dao.jaxb.GenericStepType;
import com.quantumdata.sct.dao.jaxb.InputStepType;
import com.quantumdata.sct.dao.jaxb.OptionElementType;
import com.quantumdata.sct.dao.jaxb.OptionStepType;
import com.quantumdata.sct.dao.jaxb.RangeType;
import com.quantumdata.sct.dao.jaxb.ServiceStepType;
import com.quantumdata.sct.dao.jaxb.StepParameterType;
import com.quantumdata.sct.dao.jaxb.Steps;
import com.quantumdata.sct.dao.jaxb.StepsType;
import com.quantumdata.sct.dao.jaxb.Test;
import com.quantumdata.sct.dao.jaxb.Tests;
import com.quantumdata.sct.dao.jaxb.impl.AbstractStepTypeImpl;
import com.quantumdata.sct.dao.jaxb.impl.StepsTypeImpl;
import com.quantumdata.sct.dao.vo.AbstractStepVO;
import com.quantumdata.sct.dao.vo.CompositeStepVO;
import com.quantumdata.sct.dao.vo.GenericStepVO;
import com.quantumdata.sct.dao.vo.InputStepVO;
import com.quantumdata.sct.dao.vo.OptionElementVO;
import com.quantumdata.sct.dao.vo.OptionStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.ServiceStepVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StepDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            Steps steps = (Steps)this.daoObject;
            int n = 0;
            this.daoCollection.clear();
            for (AbstractStepType abstractStepType : steps.getSteps()) {
                this.daoCollection.put(abstractStepType.getId(), new Integer(n));
                ++n;
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((Steps)this.daoObject).getSteps().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            AbstractStepType abstractStepType = (AbstractStepType)((Steps)this.daoObject).getSteps().get(i);
            iPersistableArray[i] = this.createPersistable(abstractStepType);
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Test) {
            Test test = (Test)object;
            object2 = test.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private final void copyFrom(ServiceStepType serviceStepType, ServiceStepVO serviceStepVO) throws Exception {
        serviceStepVO.setId(serviceStepType.getId());
        serviceStepVO.setDescription(serviceStepType.getDescription());
        serviceStepVO.setLastUpdate(serviceStepType.getLastUpdateDateTime());
        serviceStepVO.setMandatory(serviceStepType.isIsMandatory());
        serviceStepVO.setServiceName(serviceStepType.getName());
        this.copyFromParameters(serviceStepType, serviceStepVO);
    }

    private final void copyTo(ServiceStepType serviceStepType, ServiceStepVO serviceStepVO) throws Exception {
        serviceStepType.setId((String)serviceStepVO.getId());
        serviceStepType.setDescription(serviceStepVO.getDescription());
        serviceStepType.setIsMandatory(serviceStepVO.isMandatory());
        serviceStepType.setLastUpdateDateTime(serviceStepVO.getLastUpdate());
        serviceStepType.setName(serviceStepVO.getServiceName());
        this.copyToParameters(serviceStepType, serviceStepVO);
    }

    private final void copyTo(StepsType.CompositeStep compositeStep, CompositeStepVO compositeStepVO) throws Exception {
        compositeStep.setId((String)compositeStepVO.getId());
        compositeStep.setDescription(compositeStepVO.getDescription());
        compositeStep.setIsMandatory(compositeStepVO.isMandatory());
        compositeStep.setImageRef(compositeStepVO.getImageRef());
        compositeStep.setIsSetupStep(compositeStepVO.isSetupStep());
        compositeStep.setLastUpdateDateTime(compositeStepVO.getLastUpdate());
        compositeStep.getServiceStepOrOptionStepOrInputStep().clear();
        Iterator iterator = compositeStepVO.getChildStepsList().iterator();
        while (iterator.hasNext()) {
            AbstractStepTypeImpl abstractStepTypeImpl = null;
            AbstractStepVO abstractStepVO = (AbstractStepVO)iterator.next();
            switch (abstractStepVO.getType()) {
                case 1: {
                    StepsType.GenericStep genericStep = this.factory.createStepsTypeGenericStep();
                    this.copyTo(genericStep, (GenericStepVO)abstractStepVO);
                    abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)genericStep);
                    break;
                }
                case 2: {
                    StepsType.OptionStep optionStep = this.factory.createStepsTypeOptionStep();
                    this.copyTo(optionStep, (OptionStepVO)abstractStepVO);
                    abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)optionStep);
                    break;
                }
                case 3: {
                    StepsType.InputStep inputStep = this.factory.createStepsTypeInputStep();
                    this.copyTo(inputStep, (InputStepVO)abstractStepVO);
                    abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)inputStep);
                    break;
                }
                case 4: {
                    StepsType.ServiceStep serviceStep = this.factory.createStepsTypeServiceStep();
                    this.copyTo(serviceStep, (ServiceStepVO)abstractStepVO);
                    abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)serviceStep);
                    break;
                }
                case 5: {
                    StepsType.CompositeStep compositeStep2 = this.factory.createStepsTypeCompositeStep();
                    this.copyTo(compositeStep2, (CompositeStepVO)abstractStepVO);
                    abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)compositeStep2);
                    break;
                }
                default: {
                    throw new CreateException("Invalid Value Object being passed", null);
                }
            }
            compositeStep.getServiceStepOrOptionStepOrInputStep().add(abstractStepTypeImpl);
        }
        this.copyToParameters(compositeStep, compositeStepVO);
    }

    private final void copyToParameters(AbstractStepType abstractStepType, AbstractStepVO abstractStepVO) throws Exception {
        Collection collection = abstractStepVO.getParameters();
        if (collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RangeType rangeType;
            StepParameterType stepParameterType = this.factory.createStepParameterType();
            ParameterVO parameterVO = (ParameterVO)iterator.next();
            stepParameterType.setName(parameterVO.getName());
            stepParameterType.setValue(parameterVO.getValue());
            stepParameterType.setOutput(parameterVO.isOutput());
            stepParameterType.setFormat(parameterVO.getFormat());
            stepParameterType.setParameterType(parameterVO.getType());
            if (parameterVO.getCapLow() != null && parameterVO.getCapLow() != null) {
                rangeType = this.factory.createRangeType();
                rangeType.setHighValue(Integer.parseInt(parameterVO.getCapHigh()));
                rangeType.setLowValue(Integer.parseInt(parameterVO.getCapLow()));
                stepParameterType.setCompliance(rangeType);
            }
            if (parameterVO.getHigh() == null || parameterVO.getLow() == null) continue;
            rangeType = this.factory.createRangeType();
            rangeType.setHighValue(Integer.parseInt(parameterVO.getHigh()));
            rangeType.setLowValue(Integer.parseInt(parameterVO.getLow()));
            stepParameterType.setRange(rangeType);
        }
    }

    private final void copyFromParameters(AbstractStepType abstractStepType, AbstractStepVO abstractStepVO) throws Exception {
        if (abstractStepType.getParameters().size() <= 0) {
            return;
        }
        Iterator iterator = abstractStepType.getParameters().iterator();
        while (iterator.hasNext()) {
            RangeType rangeType;
            ParameterVO parameterVO = new ParameterVO();
            StepParameterType stepParameterType = (StepParameterType)iterator.next();
            parameterVO.setType(stepParameterType.getParameterType());
            parameterVO.setValue(stepParameterType.getValue());
            parameterVO.setName(stepParameterType.getName());
            parameterVO.setOutput(stepParameterType.isOutput());
            parameterVO.setFormat(stepParameterType.getFormat());
            parameterVO.setUserInput(stepParameterType.isUserInput());
            if (stepParameterType.getCompliance() != null) {
                rangeType = stepParameterType.getCompliance();
                parameterVO.setCapHigh(Float.toString(rangeType.getHighValue()));
                parameterVO.setCapLow(Float.toString(rangeType.getLowValue()));
            }
            if (stepParameterType.getRange() != null) {
                rangeType = stepParameterType.getRange();
                parameterVO.setHigh(Float.toString(rangeType.getHighValue()));
                parameterVO.setLow(Float.toString(rangeType.getLowValue()));
            }
            abstractStepVO.addParameter(parameterVO);
        }
    }

    private final void copyFrom(StepsType.CompositeStep compositeStep, CompositeStepVO compositeStepVO) throws Exception {
        compositeStepVO.setId(compositeStep.getId());
        compositeStepVO.setDescription(compositeStep.getDescription());
        compositeStepVO.setLastUpdate(compositeStep.getLastUpdateDateTime());
        compositeStepVO.setMandatory(compositeStep.isIsMandatory());
        compositeStepVO.setImageRef(compositeStep.getImageRef());
        compositeStepVO.setSetupStep(compositeStep.isIsSetupStep());
        for (Object e : compositeStep.getServiceStepOrOptionStepOrInputStep()) {
            AbstractStepVO abstractStepVO = null;
            if (e instanceof GenericStepType) {
                abstractStepVO = new GenericStepVO();
                this.copyFrom((GenericStepType)e, (GenericStepVO)abstractStepVO);
            } else if (e instanceof InputStepType) {
                abstractStepVO = new InputStepVO();
                this.copyFrom((InputStepType)e, (InputStepVO)abstractStepVO);
            } else if (e instanceof OptionStepType) {
                abstractStepVO = new OptionStepVO();
                this.copyFrom((OptionStepType)e, (OptionStepVO)abstractStepVO);
            } else if (e instanceof ServiceStepType) {
                abstractStepVO = new ServiceStepVO();
                this.copyFrom((ServiceStepType)e, (ServiceStepVO)abstractStepVO);
            }
            compositeStepVO.getChildStepsList().add(abstractStepVO);
        }
        this.copyFromParameters(compositeStep, compositeStepVO);
    }

    private final void copyTo(OptionStepType optionStepType, OptionStepVO optionStepVO) throws Exception {
        optionStepType.setId((String)optionStepVO.getId());
        optionStepType.setDescription(optionStepVO.getDescription());
        optionStepType.setIsMandatory(optionStepVO.isMandatory());
        optionStepType.setLastUpdateDateTime(optionStepVO.getLastUpdate());
        optionStepType.setIsMultiChoice(optionStepVO.isMultiChoice());
        ArrayList arrayList = optionStepVO.getOptionElements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            OptionElementType optionElementType = this.factory.createOptionElementType();
            OptionElementVO optionElementVO = (OptionElementVO)iterator.next();
            optionElementType.setId(optionElementVO.getOptionChoiceId());
            if (optionElementVO.isIfSelected()) {
                optionElementType.setSelected("PASS");
            } else {
                optionElementType.setSelected("FAIL");
            }
            StepParameterType stepParameterType = this.factory.createStepParameterType();
            stepParameterType.setName(optionElementVO.getParmElem().getName());
            stepParameterType.setValue(optionElementVO.getParmElem().getValue());
            optionElementType.setOptionElementTypeParameter(stepParameterType);
            optionStepType.getOption().add(optionElementType);
        }
    }

    private final void copyFrom(OptionStepType optionStepType, OptionStepVO optionStepVO) throws Exception {
        optionStepVO.setId(optionStepType.getId());
        optionStepVO.setDescription(optionStepType.getDescription());
        optionStepVO.setLastUpdate(optionStepType.getLastUpdateDateTime());
        optionStepVO.setMandatory(optionStepType.isIsMandatory());
        Iterator iterator = optionStepType.getOption().iterator();
        optionStepVO.getOptionElements().clear();
        while (iterator.hasNext()) {
            OptionElementType optionElementType = (OptionElementType)iterator.next();
            StepParameterType stepParameterType = optionElementType.getOptionElementTypeParameter();
            OptionElementVO optionElementVO = new OptionElementVO();
            if (optionElementType.getSelected().compareToIgnoreCase("PASS") == 0) {
                optionElementVO.setIfSelected(true);
            } else if (optionElementType.getSelected().compareToIgnoreCase("FAIL") == 0) {
                optionElementVO.setIfSelected(false);
            }
            optionElementVO.setOptionChoiceId(optionElementType.getId());
            ParameterVO parameterVO = new ParameterVO();
            parameterVO.setName(stepParameterType.getName());
            parameterVO.setValue(stepParameterType.getValue());
            optionElementVO.setParmElem(parameterVO);
            optionStepVO.getOptionElements().add(optionElementVO);
        }
    }

    private final void copyTo(GenericStepType genericStepType, GenericStepVO genericStepVO) throws Exception {
        genericStepType.setId((String)genericStepVO.getId());
        genericStepType.setDescription(genericStepVO.getDescription());
        genericStepType.setIsMandatory(genericStepVO.isMandatory());
        genericStepType.setLastUpdateDateTime(genericStepVO.getLastUpdate());
    }

    private final void copyFrom(GenericStepType genericStepType, GenericStepVO genericStepVO) throws Exception {
        genericStepVO.setId(genericStepType.getId());
        genericStepVO.setDescription(genericStepType.getDescription());
        genericStepVO.setLastUpdate(genericStepType.getLastUpdateDateTime());
        genericStepVO.setMandatory(genericStepType.isIsMandatory());
    }

    private final void copyTo(InputStepType inputStepType, InputStepVO inputStepVO) throws Exception {
        inputStepType.setId((String)inputStepVO.getId());
        inputStepType.setDescription(inputStepVO.getDescription());
        inputStepType.setIsMandatory(inputStepVO.isMandatory());
        inputStepType.setLastUpdateDateTime(inputStepVO.getLastUpdate());
        this.copyToParameters(inputStepType, inputStepVO);
    }

    private final void copyFrom(InputStepType inputStepType, InputStepVO inputStepVO) throws Exception {
        inputStepVO.setId(inputStepType.getId());
        inputStepVO.setDescription(inputStepType.getDescription());
        inputStepVO.setLastUpdate(inputStepType.getLastUpdateDateTime());
        inputStepVO.setMandatory(inputStepType.isIsMandatory());
        this.copyFromParameters(inputStepType, inputStepVO);
    }

    public final IPersistable createPersistable(Object object) throws Exception {
        AbstractStepVO abstractStepVO = null;
        if (object instanceof GenericStepType) {
            GenericStepVO genericStepVO = new GenericStepVO();
            this.copyFrom((GenericStepType)object, genericStepVO);
            abstractStepVO = genericStepVO;
        } else if (object instanceof InputStepType) {
            InputStepVO inputStepVO = new InputStepVO();
            this.copyFrom((InputStepType)object, inputStepVO);
            abstractStepVO = inputStepVO;
        } else if (object instanceof OptionStepType) {
            OptionStepVO optionStepVO = new OptionStepVO();
            this.copyFrom((OptionStepType)object, optionStepVO);
            abstractStepVO = optionStepVO;
        } else if (object instanceof ServiceStepType) {
            ServiceStepVO serviceStepVO = new ServiceStepVO();
            this.copyFrom((ServiceStepType)object, serviceStepVO);
            abstractStepVO = serviceStepVO;
        } else if (object instanceof StepsType.CompositeStep) {
            CompositeStepVO compositeStepVO = new CompositeStepVO();
            this.copyFrom((StepsType.CompositeStep)object, compositeStepVO);
            abstractStepVO = compositeStepVO;
        }
        return abstractStepVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void update(IPersistable iPersistable) throws UpdateException {
        if (!(iPersistable instanceof AbstractStepVO)) throw new UpdateException("Invalid Object", null);
        try {
            AbstractStepVO abstractStepVO = (AbstractStepVO)((Object)iPersistable);
            if (!this.daoCollection.containsKey(abstractStepVO.getId()) || !abstractStepVO.isDirty()) return;
            Object v = this.daoCollection.get(abstractStepVO.getId());
            System.out.println(v.getClass().getName());
            Integer n = (Integer)this.daoCollection.get(abstractStepVO.getId());
            Object e = ((Steps)this.daoObject).getSteps().get(n);
            if (e instanceof StepsType.GenericStep && abstractStepVO instanceof GenericStepVO) {
                this.copyTo((StepsType.GenericStep)e, (GenericStepVO)abstractStepVO);
                return;
            } else if (e instanceof StepsType.InputStep && abstractStepVO instanceof InputStepVO) {
                this.copyTo((StepsType.InputStep)e, (InputStepVO)abstractStepVO);
                return;
            } else if (e instanceof StepsType.OptionStep && abstractStepVO instanceof OptionStepVO) {
                this.copyTo((StepsType.OptionStep)e, (OptionStepVO)abstractStepVO);
                return;
            } else if (e instanceof StepsType.ServiceStep) {
                this.copyTo((StepsType.ServiceStep)e, (ServiceStepVO)abstractStepVO);
                return;
            } else {
                if (!(e instanceof StepsType.CompositeStep)) return;
                this.copyTo((StepsType.CompositeStep)e, (CompositeStepVO)abstractStepVO);
            }
            return;
        }
        catch (Exception exception) {
            throw new UpdateException(exception.getMessage(), null, exception);
        }
    }

    protected void updateObject(IPersistable iPersistable) throws Exception {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            Object e = ((Steps)this.daoObject).getSteps().get(n);
            if (e instanceof StepsType.GenericStep && iPersistable instanceof GenericStepVO) {
                this.copyTo((StepsType.GenericStep)e, (GenericStepVO)iPersistable);
            } else if (e instanceof StepsType.InputStep && iPersistable instanceof InputStepVO) {
                this.copyTo((StepsType.InputStep)e, (InputStepVO)iPersistable);
            } else if (e instanceof StepsType.OptionStep && iPersistable instanceof OptionStepVO) {
                this.copyTo((StepsType.OptionStep)e, (OptionStepVO)iPersistable);
            } else if (e instanceof StepsType.ServiceStep) {
                this.copyTo((StepsType.ServiceStep)e, (ServiceStepVO)iPersistable);
            } else if (e instanceof StepsType.CompositeStep) {
                this.copyTo((StepsType.CompositeStep)e, (CompositeStepVO)iPersistable);
            }
        }
    }

    protected final IPersistable findByPrimaryKey(String string) throws Exception {
        AbstractStepVO abstractStepVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            Object e = ((Steps)this.daoObject).getSteps().get(n);
            if (e instanceof StepsTypeImpl.CompositeStepImpl) {
                abstractStepVO = new CompositeStepVO();
                this.copyFrom((StepsTypeImpl.CompositeStepImpl)e, (CompositeStepVO)abstractStepVO);
            } else if (e instanceof StepsTypeImpl.GenericStepImpl) {
                abstractStepVO = new GenericStepVO();
                this.copyFrom((StepsTypeImpl.GenericStepImpl)e, (GenericStepVO)abstractStepVO);
            } else if (e instanceof StepsTypeImpl.InputStepImpl) {
                abstractStepVO = new InputStepVO();
                this.copyFrom((StepsTypeImpl.InputStepImpl)e, (InputStepVO)abstractStepVO);
            } else if (e instanceof StepsTypeImpl.OptionStepImpl) {
                abstractStepVO = new OptionStepVO();
                this.copyFrom((StepsTypeImpl.OptionStepImpl)e, (OptionStepVO)abstractStepVO);
            } else if (e instanceof StepsTypeImpl.ServiceStepImpl) {
                abstractStepVO = new ServiceStepVO();
                this.copyFrom((StepsTypeImpl.ServiceStepImpl)e, (ServiceStepVO)abstractStepVO);
            }
        }
        return abstractStepVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Steps)this.daoObject).getSteps().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((Tests)this.daoObject).getTestsCollection().size();
            if (n < 0 || n > n2) {
                throw new CreateException("Invalid Index. Cannot be greater than zero", null);
            }
            if (iPersistable instanceof AbstractStepVO) {
                AbstractStepVO abstractStepVO = (AbstractStepVO)((Object)iPersistable);
                AbstractStepTypeImpl abstractStepTypeImpl = null;
                switch (abstractStepVO.getType()) {
                    case 1: {
                        StepsType.GenericStep genericStep = this.factory.createStepsTypeGenericStep();
                        this.copyTo(genericStep, (GenericStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)genericStep);
                        break;
                    }
                    case 2: {
                        StepsType.OptionStep optionStep = this.factory.createStepsTypeOptionStep();
                        this.copyTo(optionStep, (OptionStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)optionStep);
                        break;
                    }
                    case 3: {
                        StepsType.InputStep inputStep = this.factory.createStepsTypeInputStep();
                        this.copyTo(inputStep, (InputStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)inputStep);
                        break;
                    }
                    case 4: {
                        StepsType.ServiceStep serviceStep = this.factory.createStepsTypeServiceStep();
                        this.copyTo(serviceStep, (ServiceStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)serviceStep);
                        break;
                    }
                    case 5: {
                        StepsType.CompositeStep compositeStep = this.factory.createStepsTypeCompositeStep();
                        this.copyTo(compositeStep, (CompositeStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)compositeStep);
                        break;
                    }
                    default: {
                        throw new CreateException("Invalid Value Object being passed", null);
                    }
                }
                ((Steps)this.daoObject).getSteps().add(n, abstractStepTypeImpl);
                this.flush();
                this.readCallback();
            }
        }
        catch (Exception exception) {
            throw new CreateException("Error add Persistable object", null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (iPersistable instanceof AbstractStepVO) {
                AbstractStepVO abstractStepVO = (AbstractStepVO)((Object)iPersistable);
                AbstractStepTypeImpl abstractStepTypeImpl = null;
                switch (abstractStepVO.getType()) {
                    case 1: {
                        StepsType.GenericStep genericStep = this.factory.createStepsTypeGenericStep();
                        this.copyTo(genericStep, (GenericStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)genericStep);
                        break;
                    }
                    case 2: {
                        StepsType.OptionStep optionStep = this.factory.createStepsTypeOptionStep();
                        this.copyTo(optionStep, (OptionStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)optionStep);
                        break;
                    }
                    case 3: {
                        StepsType.InputStep inputStep = this.factory.createStepsTypeInputStep();
                        this.copyTo(inputStep, (InputStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)inputStep);
                        break;
                    }
                    case 4: {
                        StepsType.ServiceStep serviceStep = this.factory.createStepsTypeServiceStep();
                        this.copyTo(serviceStep, (ServiceStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)serviceStep);
                        break;
                    }
                    case 5: {
                        StepsType.CompositeStep compositeStep = this.factory.createStepsTypeCompositeStep();
                        this.copyTo(compositeStep, (CompositeStepVO)abstractStepVO);
                        abstractStepTypeImpl = (AbstractStepTypeImpl)((Object)compositeStep);
                        break;
                    }
                    default: {
                        throw new CreateException("Invalid Value Object being passed", null);
                    }
                }
                ((Steps)this.daoObject).getSteps().add(abstractStepTypeImpl);
                this.flush();
                this.readCallback();
            }
        }
        catch (Exception exception) {
            throw new CreateException("Error add Persistable object", null, exception);
        }
    }
}

